#define RECORDERNAME "Ogg Vorbis Recorder by CyanPhase"

#include "recorder.h"
#include "ogg-include/codec.h"
#include "ogg-include/vorbisenc.h"
#include "resource.h"
  
class rec : public COOERecorder {
public:
	virtual bool __cdecl Init();

	virtual bool __cdecl IsMultiTrack() { return false; };
	virtual bool __cdecl IsTagged() { return true; };
	virtual bool __cdecl IsStreamed() { return false; };
	virtual bool __cdecl IsRequiresWaveout() { return false; };
	virtual bool __cdecl IsLossyCompression() { return false; };

	virtual bool __cdecl IsSampleRateChangeable() { return false; };
	virtual bool __cdecl SampleRateChanged(int samplerate) { return false; };
	virtual bool __cdecl IsBitRateChangeable() { return false; };
	virtual bool __cdecl BitRateChanged(int bitrate) { return false; };

	virtual bool __cdecl SupportsSampleRate(int samplerate) { return true; };
	virtual bool __cdecl SupportsBitRate(int bitrate) { return true; };

	virtual bool __cdecl SaveAs(HWND parentwindow);
	virtual bool __cdecl ReadyToRec();

	virtual bool __cdecl TrackNames(int track_id, char *track_name) { return true; };
	virtual bool __cdecl SongTagData(int tag_index, char *tagdata);

    virtual bool __cdecl Start(char * filename, int samplespersec);
    virtual bool __cdecl WorkOutput(float *psamples, int numsamples);
	virtual bool __cdecl WorkOutputMulti(int track_id, float *psamples, int numsamples) { return false; };

    virtual bool __cdecl Finish();
    virtual void __cdecl ConfigDlg(HWND parentwindow);
	virtual void __cdecl DispatchCommand(int command_id, int param1, int param2, int param3, int param4);
	virtual void __cdecl DispatchCommandEx(char * str_command, char * str_value);

	virtual void __cdecl LoadSettings(char * settingsname, char *username, char *domain) { };
	virtual void __cdecl SaveSettings(char * settingsname, char *username, char *domain) { };

	virtual char * __cdecl OutputFilename();
    virtual char * __cdecl OutputSize();
	virtual char * __cdecl ExtraInfo(int extra_info_id) { return "No Extra Info"; };
	virtual char * __cdecl RecordersWebSiteURL() { return "http://www.buzzscene.ca/"; };

	virtual int __cdecl RecorderVersion() { return 100; };

	virtual void GetRecorderExtensionsClass(int param, void **exmodule) { };
public:
	char myfilename[255];
	FILE * myfilehandle;
	unsigned int writtensofar;
	int bitdepth;

	int samplerate;

	char song_title[255];
	char song_artist[255];
	char song_name[255];
	char song_genre[255];
	char song_keywords[255];
	char song_comments[255];
	char song_copyright[255];
	char song_year[255];
	char song_softpak[255];

	vorbis_comment   vc;
	vorbis_dsp_state vd;
	vorbis_block     vb;
	vorbis_info      vi;
	ogg_stream_state os;
	ogg_page         og;
	ogg_packet       op;
	FILE *           flout;
	long             samplesdone;
	int              eos;
	long             bytes_written, packetsdone;
	double           time_elapsed;
	int              ret;
//	TIMER *          timer;
	int              kbps_setting;
	int              bitratebuf;
	int              selbit;

};

bool rec::Init(){
	sprintf(myfilename, "");
	myfilehandle = NULL;
	writtensofar = 0;
	bitdepth = 0;
	selbit = 2;
	return true;
}
bool rec::SaveAs(HWND parentwindow){
	OPENFILENAME ofl;
	char filename[255];
	int nSuccess;

	sprintf(filename,"Untitled.ogg");
	ofl.lStructSize = sizeof(ofl);
	ofl.hwndOwner = parentwindow;
	ofl.hInstance = dllInstance;
	ofl.lpstrFilter = "Ogg Vorbis File (*.ogg)\0*.ogg\0";
	ofl.lpstrCustomFilter = NULL;
	ofl.nMaxCustFilter = NULL;
	ofl.nFilterIndex = 1;
	ofl.lpstrFile = filename;
	ofl.nMaxFile = 255;
	ofl.lpstrFileTitle = NULL;
	ofl.nMaxFileTitle = NULL;
	ofl.lpstrInitialDir = NULL;
	ofl.lpstrTitle = "Save Song Output as";
	ofl.Flags = OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST;
	ofl.nFileOffset = 0;
	ofl.nFileExtension = 0;
	ofl.lpstrDefExt = ".ogg";
	ofl.lCustData = NULL;
	ofl.lpfnHook = NULL;
	ofl.lpTemplateName = NULL;
	nSuccess = GetSaveFileName(&ofl);
	if (nSuccess == 0) {
		sprintf(myfilename, "");
//		SetWindowText(GetDlgItem(hDlg, IDC_FILENAMEBTN), "Save As...");
	} else {
		sprintf(myfilename, ofl.lpstrFile);
//		SetWindowText(GetDlgItem(hDlg, IDC_FILENAMEBTN), ext_hdfilename);
	}
	return true;
}
char *rec::OutputFilename() {
	return myfilename;
}
bool rec::Start (char * filename, int samplespersec) {
	samplerate = samplespersec;
	samplesdone = 0;
	bytes_written = 0;
	packetsdone = 0;
	ret = 0;
	switch (selbit) {
	case 0: kbps_setting = 64; break;
	case 1: kbps_setting = 80; break;
	case 2: kbps_setting = 96; break;
	case 3: kbps_setting = 112; break;
	case 4: kbps_setting = 128; break;
	case 5: kbps_setting = 160; break;
	case 6: kbps_setting = 192; break;
	case 7: kbps_setting = 224; break;
	case 8: kbps_setting = 256; break;
	case 9: kbps_setting = 288; break;
	case 10: kbps_setting = 320; break;
	case 11: kbps_setting = 352; break;
	default: kbps_setting = 96;
	}

	vorbis_comment_init(&vc);
	flout = fopen(filename, "wb");
	bitratebuf = kbps_setting;

//	timer = timer_start();

	vorbis_info_init(&vi);
	vorbis_encode_init(&vi, 2, samplerate, -1, bitratebuf*1000, -1);
	vorbis_analysis_init(&vd,&vi);
	vorbis_block_init(&vd,&vb);
	ogg_stream_init(&os, 882940);

	{
		ogg_packet header_main;
		ogg_packet header_comments;
		ogg_packet header_codebooks;
		int result;
		vorbis_analysis_headerout(&vd,&vc, &header_main,&header_comments,&header_codebooks);
		ogg_stream_packetin(&os,&header_main);
		ogg_stream_packetin(&os,&header_comments);
		ogg_stream_packetin(&os,&header_codebooks);
		while((result = ogg_stream_flush(&os, &og)))
		{
			if(!result) break;
            ret = fwrite(og.header,1,og.header_len, flout);
            ret += fwrite(og.body,1,og.body_len, flout);
			if(!ret) {
				MessageBox(NULL, "Failed writing header to output stream\n", "OggVorbis Encoder", MB_OK);
				ret = 1;
				vorbis_block_clear(&vb);
				vorbis_dsp_clear(&vd);
				vorbis_info_clear(&vi);
				fflush(flout);
				fclose(flout);
			} else bytes_written += ret;
		}
	}

	eos = 0;

	writtensofar = 0;

	return true;
}

bool rec::ReadyToRec() {
	if (strcmp(myfilename, "") == 0) {
		return false;
	} else {
		return true;
	}
}

bool rec::SongTagData(int tag_index, char *tagdata) {
	if (strlen(tagdata) > 250) tagdata[250] = 0;
	switch (tag_index) {
	case 0: sprintf(song_title, tagdata);    return true; break;
	case 1: sprintf(song_artist, tagdata);   return true; break;
	case 2: sprintf(song_name, tagdata);    return true; break;
	case 3: sprintf(song_genre, tagdata);    return true; break;
	case 4: sprintf(song_keywords, tagdata); return true; break;
	case 5: sprintf(song_comments, tagdata); return true; break;
	case 9: sprintf(song_copyright, tagdata);return true; break;
	case 10: sprintf(song_year, tagdata);    return true; break;
	case 13: sprintf(song_softpak, tagdata); return true; break;
	default: return false; break;
	}
}

bool rec::WorkOutput (float *psamples, int numsamples) {
	int i_rn;
	int i_rx = 0;
    float **buffer = vorbis_analysis_buffer(&vd, numsamples);
    for (i_rn = 0; i_rn < (numsamples*2); i_rn++) {
        buffer[0][i_rx] = psamples[i_rn] / 32768.0f;
        i_rn++;
        buffer[1][i_rx] = psamples[i_rn] / 32768.0f;
		i_rx++;
    }
    if(numsamples == 0) {
        vorbis_analysis_wrote(&vd,0);
    } else {
        samplesdone += numsamples*2;
        vorbis_analysis_wrote(&vd, numsamples);
    }
    while(vorbis_analysis_blockout(&vd,&vb)==1) {
        vorbis_analysis(&vb, &op);
		vorbis_bitrate_addblock(&vb); // new in 1.0
		while(vorbis_bitrate_flushpacket(&vd, &op)) {
			ogg_stream_packetin(&os,&op);
			packetsdone++;
			while(!eos) {
				int result = ogg_stream_pageout(&os,&og);
				if(!result) break;
				ret = fwrite(og.header,1,og.header_len, flout);
				ret += fwrite(og.body,1,og.body_len, flout);
				if(!ret)
				{
					MessageBox(NULL, "Failed writing data to output stream\n", "OggVorbis Encoder", MB_OK);
					ret = 1;
					ogg_stream_clear(&os);
					vorbis_block_clear(&vb);
					vorbis_dsp_clear(&vd);
					vorbis_info_clear(&vi);
					fflush(flout);
					fclose(flout);
				} else bytes_written += ret; 
				if(ogg_page_eos(&og)) eos = 1;
			}
		}
    }

	return true;
}

bool rec::Finish() {
    vorbis_block_clear(&vb);
    vorbis_dsp_clear(&vd);
    vorbis_info_clear(&vi);
	fflush(flout);
	fclose(flout);
	return true;
}

char * rec::OutputSize() {
	static char megs[32];
	switch (bitdepth) {
	case 0:
		sprintf(megs, "%.2fM", ((float)writtensofar * 4.0f / 1024.0f / 1024.0f));
		break;
	case 1:
		sprintf(megs, "%.2fM", ((float)writtensofar * 6.0f / 1024.0f / 1024.0f));
		break;
	case 2:
		sprintf(megs, "%.2fM", ((float)writtensofar * 2.0f * (float)sizeof(float) / 1024.0f / 1024.0f));
		break;
	case 3:
		sprintf(megs, "%.2fM", ((float)writtensofar * 2.0f * (float)sizeof(int) / 1024.0f / 1024.0f));
		break;
	default:
		sprintf(megs, "%.2fM", ((float)writtensofar * 4.0f / 1024.0f / 1024.0f));
		break;
	}
	return megs;
}

rec *prec;

BOOL APIENTRY ConfigDialog (HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch(uMsg) {
	case WM_INITDIALOG:
	{
		SendMessage(GetDlgItem(hDlg, IDC_QCOMBO), CB_RESETCONTENT, 0, 0);
		SendMessage(GetDlgItem(hDlg, IDC_QCOMBO), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("64 kbps Stereo"));
		SendMessage(GetDlgItem(hDlg, IDC_QCOMBO), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("80 kbps Stereo"));
		SendMessage(GetDlgItem(hDlg, IDC_QCOMBO), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("96 kbps Stereo"));
		SendMessage(GetDlgItem(hDlg, IDC_QCOMBO), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("112 kbps Stereo"));
		SendMessage(GetDlgItem(hDlg, IDC_QCOMBO), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("128 kbps Stereo"));
		SendMessage(GetDlgItem(hDlg, IDC_QCOMBO), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("160 kbps Stereo"));
		SendMessage(GetDlgItem(hDlg, IDC_QCOMBO), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("192 kbps Stereo"));
		SendMessage(GetDlgItem(hDlg, IDC_QCOMBO), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("224 kbps Stereo"));
		SendMessage(GetDlgItem(hDlg, IDC_QCOMBO), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("256 kbps Stereo"));
		SendMessage(GetDlgItem(hDlg, IDC_QCOMBO), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("288 kbps Stereo"));
		SendMessage(GetDlgItem(hDlg, IDC_QCOMBO), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("320 kbps Stereo"));
		SendMessage(GetDlgItem(hDlg, IDC_QCOMBO), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("352 kbps Stereo"));
		SendMessage(GetDlgItem(hDlg, IDC_QCOMBO), CB_SETCURSEL, (int)(prec->selbit), 0);

		return 1;
	}
	case WM_SHOWWINDOW:
	{
		return 1;
	}
	case WM_CLOSE:
	{
		EndDialog (hDlg, TRUE);
	}
	case WM_COMMAND:
		switch ( LOWORD (wParam))
		{
		case IDOK:
			prec->selbit = (int)SendMessage(GetDlgItem(hDlg, IDC_QCOMBO), CB_GETCURSEL, 0, 0);
			switch (prec->selbit) {
			case 0: prec->kbps_setting = 64; break;
			case 1: prec->kbps_setting = 80; break;
			case 2: prec->kbps_setting = 96; break;
			case 3: prec->kbps_setting = 128; break;
			case 4: prec->kbps_setting = 160; break;
			case 5: prec->kbps_setting = 192; break;
			case 6: prec->kbps_setting = 256; break;
			case 7: prec->kbps_setting = 350; break;
			default: prec->kbps_setting = 96;
			}
			
			EndDialog (hDlg, TRUE);
			break;
		case IDCANCEL:
			EndDialog (hDlg, TRUE);
			break;
		default:
			return 0;
		}
		break;
	}
	return 0;
}

BOOL APIENTRY AboutDialog (HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch(uMsg) {
	case WM_INITDIALOG:
	{
		SetDlgItemText(hDlg, IDC_EDIT1, "Ogg Vorbis 1.0 Recorder 1.3\r\n"
										"Coded by Edward L. Blake aka. CyanPhase\r\n"
										"Using the Ogg Vorbis 1.0 libraries.\r\n\r\n"
										"This plugin is part of Overloader\r\n"
										"Get the latest version at: \r\n"
										"   http://www.buzzscene.ca/\r\n\r\n"
										"Contact me at:\r\n"
										"   blakee@rovoscape.com\r\n\r\n"
										"Find out more about Ogg Vorbis at:\r\n"
										"   http://www.vorbis.com/\r\n");

		return 1;
	}
	case WM_SHOWWINDOW:
	{
		return 1;
	}
	case WM_CLOSE:
	{
		EndDialog (hDlg, TRUE);
	}
	case WM_COMMAND:
		switch ( LOWORD (wParam))
		{
		case IDOK:
			EndDialog (hDlg, TRUE);
			break;
		case IDCANCEL:
			EndDialog (hDlg, TRUE);
			break;
		default:
			return 0;
		}
		break;
	}
	return 0;
}

void rec::ConfigDlg (HWND parentwindow) {
	prec = this;
	DialogBox(dllInstance, MAKEINTRESOURCE (IDD_CONFIG), parentwindow, (DLGPROC) &ConfigDialog);
}

void rec::DispatchCommand(int command_id, int param1, int param2, int param3, int param4) {

}

void rec::DispatchCommandEx(char * str_command, char * str_value) {
	if (strcmp(str_command, "about") == 0) {
		DialogBox(dllInstance, MAKEINTRESOURCE (IDD_ABOUTBOX), *(HWND*)str_value, (DLGPROC) &AboutDialog);
	}
}

EXPORTTHING